<?php

namespace App\Modules\Finance\Migrations\Asset;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Asset extends Model 
{

    protected $table = 'fi_assets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function assetCategory()
    {
        return $this->belongsTo('AssetCategory', 'asset_category_id');
    }

    public function assetAccount()
    {
        return $this->belongsTo('SystemAccounts', 'asset_account_id');
    }

    public function depreciationExpense()
    {
        return $this->belongsTo('SystemAccounts', 'depreciation_account_id');
    }

    public function depreciationCollection()
    {
        return $this->belongsTo('SystemAccounts', 'depreciation_collection_id');
    }

}